<?php
namespace ds_srt_overlap_removal;
class Shortcode {
    /**
     * Constructor
     * @return void
     */
    function __construct() {
    }
    /**
     * Include template file to generate Html output
     * @param string $file Name of the template file (without extension) located in templates, may include subdirectory
     * @param array $args (Optional) Array of arguments to be made available in template file
     * @return string Return Html output or Error message
     */
    public function getShortcode() {
        $dsSrtOverlapRemovalTexts = array('nonce' => wp_create_nonce('ds_srt_overlap_removal_ajax'), 'ajax' => admin_url( 'admin-ajax.php' ));
        wp_register_script('ds_srt_overlap_removal', PLUGIN_URL . '/js/tool.js', ['jquery-core'], null, true);
        wp_localize_script('ds_srt_overlap_removal', 'dsSrtOverlapRemovalTexts', apply_filters('ds_srt_overlap_removal_script', $dsSrtOverlapRemovalTexts));
        wp_enqueue_script('ds_srt_overlap_removal');
        return Template::getTemplate('tool');
    }
}
