<?php
/**
 * Plugin Name: Srt Overlap Removal
 * Plugin URI: https://www.werbe-markt.de/wordpress-tool-srt-overlap-removal.php
 * Description: Provides a Shortcode which displays a Tool to remove Subtitle Overlaps in Srt files.
 * Version: 1.0.1
 * Author: d_spaete
 * Author URI: https://www.werbe-markt.de/
 * Text Domain: ds-srt-overlap-removal
 * Domain Path: /languages/
 */
namespace ds_srt_overlap_removal;
/**
 * No direct access
 */
if (!defined('ABSPATH')) {
    exit;
}
define(__NAMESPACE__ . '\PLUGIN_URL', plugins_url('', __FILE__));
define(__NAMESPACE__ . '\TEXT_DOMAIN', 'ds-srt-overlap-removal');
define(__NAMESPACE__ . '\TEMPLATE_DIR', plugin_dir_path(__FILE__) . 'templates');

$description=_('Provides a Shortcode which displays a Tool to remove Subtitle Overlaps in Srt files.');

/**
 * Set up autoloading
 */
spl_autoload_register(function ($class) {
    $class = str_replace(__NAMESPACE__ . '\\', '', $class);
    $class = str_replace('\\', '/', $class);
    if (file_exists(__DIR__ . '/lib/' . $class . '.php')) {
        include (__DIR__ . '/lib/' . $class . '.php');
    }
});
/**
 * Provide the shortcode
 */
add_shortcode('ds_srt_overlap_removal', [new Shortcode(), 'getShortcode']);
/**
 * Setup for handling XHR-Requests
 */
add_action('wp_ajax_nopriv_ds_srt_overlap_removal_handler', [new Ajax(), 'handle']);
add_action('wp_ajax_ds_srt_overlap_removal_handler', [new Ajax(), 'handle']);
/**
 * Register Settings when Plugin is activated
 */
register_activation_hook(__FILE__, [new Install(), 'install']);
/**
 * Update Settings when Plugin is deactivated
 */
register_deactivation_hook(__FILE__, [new Deactivate(), 'deactivate']);
/**
 * Namespace depending translate functions for giving the Text domain to WordPress __()
 */
function __($text) {
    return \__($text, TEXT_DOMAIN);
}
function _e($text) {
    \_e($text, TEXT_DOMAIN);
}
function _x($text, $context) {
    return \__($text, TEXT_DOMAIN);
}
function _ex($text, $context) {
    \_e($text, TEXT_DOMAIN);
}
function _nx($single, $plural, $number, $context) {
    return \_n($single, $plural, $number, TEXT_DOMAIN);
}
