<?php
namespace ds_srt_overlap_removal;
class Template {
    public static function getTemplate($file, $args = []) {
        $templateFile = apply_filters('ds_srt_overlap_removal_template', TEMPLATE_DIR . '/' . $file . '.php');
        if (file_exists(get_stylesheet_directory() . '/' . TEXT_DOMAIN . '/' . $file . '.php')) {
            $templateFile = get_stylesheet_directory() . '/' . TEXT_DOMAIN . '/' . $file . '.php';
        }
        if (file_exists($templateFile)) {
            ob_start();
            include ($templateFile);
            $ret = ob_get_clean();
            return $ret;
        } else {
            $tplTemplateFile = (defined('WP_DEBUG') && WP_DEBUG) ? $templateFile : '';
            return sprintf(__('Template File %s does not exist.'), $tplTemplateFile);
        }
    }
}
