<?php
namespace ds_srt_overlap_removal;
class Ajax {
    private $response = ['res' => null, 'status' => ['success' => true, 'msg' => '']];
    /**
     * Constructor
     * @return void
     */
    function __construct() {
    }
    /**
     * Handling all ajax-Requests
     * @return void
     */
    public function handle() {
        do_action('ds_srt_overlap_removal_ajax_handle');
        if (!check_ajax_referer('ds_srt_overlap_removal_ajax', 'nonce')) {
            $this->err(_('Nonce Verification failed'));
        } elseif (!isset($_POST['srt'])) {
            $this->err(_('Invalid Request'));
        } else {
            $this->parseInput((string)$_POST['srt']);
        }
        $this->respond();
    }
    /**
     * Try to parse input and set response message
     * @param string $srtSrc
     * @return void
     */
    private function parseInput($srtSrc) {
        $srtSrc = trim($srtSrc);
        $srtSrc = explode("\n", $srtSrc);
        $c = 0;
        $skipNextRow = false;
        $starts = [];
        foreach ($srtSrc as $line) {
            $line = trim($line);
            if (empty($line) || is_numeric($line) || $skipNextRow) {
                if ($skipNextRow) {
                    $text[$c] = $line;
                }
                $skipNextRow = false;
                continue;
            }
            if (preg_match("/^\d\d:\d\d:/", $line)) {
                $c++;
                $dates = explode(' --> ', $line);
                if (count($dates) !== 2) {
                    $this->err(_('Unable to parse input'));
                }
                //~ $starts[$c] = (int)preg_replace("/\D/", '', $dates[0]);
                //~ $ends[$c] = (int)preg_replace("/\D/", '', $dates[1]);
                sscanf($dates[0], "%d:%d:%d,%d", $hours, $minutes, $seconds, $milliseconds);
                $starts[$c] = ($hours * 3600 + $minutes * 60 + $seconds) * 1000 + $milliseconds;
                sscanf($dates[1], "%d:%d:%d,%d", $hours, $minutes, $seconds, $milliseconds);
                $ends[$c] = ($hours * 3600 + $minutes * 60 + $seconds) * 1000 + $milliseconds;
                if ($c > 1 && $starts[$c] < $ends[$c - 1]) {
                    $ends[$c - 1] = (int)($starts[$c - 1] + ($ends[$c - 1] - $starts[$c - 1]) / 2);
                    $starts[$c] = $ends[$c - 1];
                }
                $skipNextRow = true;
            }
        }
        if (empty($starts)) {
            $this->err(_('Unable to parse input'));
        }
        $keys = array_keys($starts);
        foreach ($keys as $key) {
            $this->response['res'].= $key . "\n";
            $startX = (int)($minutes = (int)($seconds = (int)($milliseconds = (int)($starts[$key])) / 1000) / 60) / 60;
            $this->response['res'].= sprintf("%02d:%02d:%02d,%03d", $hours, ($minutes % 60), ($seconds % 60), $milliseconds % 1000) . ' --> ';
            $endX = (int)($minutes = (int)($seconds = (int)($milliseconds = (int)($ends[$key])) / 1000) / 60) / 60;
            $this->response['res'].= sprintf("%02d:%02d:%02d,%03d", $hours, ($minutes % 60), ($seconds % 60), $milliseconds % 1000) . ' --> ';
            $this->response['res'].= $text[$key] . "\n\n";
        }
    }
    /**
     * Set error message
     * @param string $msg
     * @return void
     */
    private function err($msg) {
        $this->response['status']['success'] = false;
        $this->response['status']['msg'] = $this->getTemplate('err', ['msg' => __(apply_filters('ds_srt_overlap_removal_ajax_msg', $msg)) ]);
    }
    /**
     * Generate the JSON output send to the client
     * @return void
     */
    private function respond() {
        echo json_encode(apply_filters('ds_srt_overlap_removal_ajax_response', $this->response));
        die;
    }
    /**
     * Load template as Response
     * @param string $template Name of the template file (without extension) located in templates/ajax
     * @param array|null $args Array of arguments to pass to the template method
     * @return void
     */
    private function getTemplate($template, $args = []) {
        return Template::getTemplate('ajax/' . $template, $args);
    }
}
