<?php
/**
 * Plugin Name: Shopauskunft.de-Bewertungslink für WooCommerce
 * Plugin URI:  https://www.werbe-markt.de/woocommerce-shopauskunft-bewertungslink.php
 * Description: Zeigt den Shopauskunft.de-Bewertungslink für WooCommerce-Bestellungen im WordPress-Admin.
 * Author:      d_spaete
 * Author URI:  https://www.werbe-markt.de/
 *
 *
 */
namespace ds_woocommerce_shopauskunft_link;
/**
 * No direct access
 */
if (!defined('ABSPATH')) {
    exit;
}
define(__NAMESPACE__ . '\TEXT_DOMAIN', 'ds-woocommerce-shopauskunft-link');
define(__NAMESPACE__ . '\TEMPLATE_DIR', plugin_dir_path(__FILE__) . 'templates');
/**
 * Set up autoloading
 */
spl_autoload_register(function ($class) {
    $class = str_replace(__NAMESPACE__ . '\\', '', $class);
    $class = str_replace('\\', '/', $class);
    if (file_exists(__DIR__ . '/lib/' . $class . '.php')) {
        include (__DIR__ . '/lib/' . $class . '.php');
    }
});
/**
 * Add Settings page to WP admin
 */
add_action('admin_menu', [new Settings(), 'init']);
/**
 * Add the link in WooCommerce order details
 */
add_action('woocommerce_admin_order_data_after_order_details', function ($order) {
    $user = $order->get_user();
    $params = [];
    $params['xc__label'] = get_option(__NAMESPACE__ . '_settings') ['shop_id'];
    $params['bestellnr'] = $order->get_order_number();
    $params['email'] = $order->get_billing_email();
    $params['bestelldatum'] = date('d.m.Y', strtotime($order->get_date_created()));
    $params['warenwert'] = $order->get_total();
    $params['username'] = $user ? $user->__get('user_login') : '';
    echo '<p class="form-field form-field-wide">';
    echo '<label><a href="https://www.shopauskunft.de/neue-bewertung?' . http_build_query($params) . '">Shopauskunft-Bewertungslink</a></label>';
    echo '</p>';
}, 90, 1);
/**
 * Add Settings link to options page in plugin list
 */
add_action('plugin_action_links_' . plugin_basename(__FILE__), function ($links) {
    $newLink[] = sprintf('<a href="options-general.php?page=' . TEXT_DOMAIN . '">%s</a>', __('Settings'));
    return array_merge($newLink, $links);
});
