<?php
namespace ds_woocommerce_shopauskunft_link;
class Settings {
    private $capability;
    private $settings = ['shop_id' => ''];
    /**
     * Constructor
     * @return void
     */
    function __construct() {
        $this->settings = get_option(__NAMESPACE__ . '_settings');
        if ((isset($_GET['page']) && $_GET['page'] === TEXT_DOMAIN) || (isset($_POST['option_page']) && $_POST['option_page'] === __NAMESPACE__ . '_settings')) {
            $this->capability = apply_filters(__NAMESPACE__ . '_capability', 'manage_options');
        }
    }
    /**
     * Main handler for settings page
     * @return void
     */
    public function init() {
        add_action('admin_init', function () {
            register_setting(__NAMESPACE__ . '_settings', 'settings_page_' . TEXT_DOMAIN, array(&$this, 'saveOptions'));
        });
        $pageSlug = $this->addOptionsPage();
    }
    /**
     * Add options page to WordPress admin
     * @return string hook_suffix
     */
    private function addOptionsPage() {
        return add_options_page(__('Shopauskunft Bewertungslink'), __('Shopauskunft Bewertungslink'), $this->capability, TEXT_DOMAIN, [&$this, 'generatePage']);
    }
    /**
     * Build and echo the settings page
     * @return void
     */
    public function generatePage() {
        add_settings_section(__NAMESPACE__ . '_settings', __('Shopauskunft Shop-ID'), [&$this, 'renderShopIdSection'], __NAMESPACE__ . '_settings');
        add_settings_field('shop_id', __('Shop-ID'), array(&$this, 'renderShopIdFields'), __NAMESPACE__ . '_settings', __NAMESPACE__ . '_settings', ['id' => 'shop_id']);
        echo $this->getTemplate('settings');
    }
    /**
     * Save settings
     * @return void
     */
    public function saveOptions() {
        if (current_user_can($this->capability) && isset($_POST[__NAMESPACE__ . '_settings_nonce']) && wp_verify_nonce($_POST[__NAMESPACE__ . '_settings_nonce'], __NAMESPACE__ . '_settings_nonce')) {
            update_option(__NAMESPACE__ . '_settings', ['shop_id' => $_POST['shop_id']]);
        }
    }
    /**
     * Must be implemented for to use Settings API
     * @return void
     */
    public function renderShopIdSection() {
    }
    /**
     * Echo the priority section
     * @param array $args ('id' => string)
     * @return void
     */
    public function renderShopIdFields($args) {
        $args['shop_id'] = $this->settings['shop_id'];
        echo $this->getTemplate('settings/shop_id', $args);
    }
    /**
     * Echo WooCommerce integration section: VAT Id input field
     * @param array $args ('id' => string)
     * @return void
     */
    public function getTemplate($file, $args = []) {
        $templateFile = apply_filters('ds_srt_overlap_removal_template', TEMPLATE_DIR . '/' . $file . '.php');
        if (file_exists(get_stylesheet_directory() . '/' . TEXT_DOMAIN . '/' . $file . '.php')) {
            $templateFile = get_stylesheet_directory() . '/' . TEXT_DOMAIN . '/' . $file . '.php';
        }
        if (file_exists($templateFile)) {
            ob_start();
            include ($templateFile);
            $ret = ob_get_clean();
            return $ret;
        } else {
            $tplTemplateFile = (defined('WP_DEBUG') && WP_DEBUG) ? $templateFile : '';
            return sprintf(__('Template File %s does not exist.'), $tplTemplateFile);
        }
    }
}
