<?php

namespace WMSonderpreisAbsolut;

class DiscountPriceHandler
{
    public static function getDiscount($productId, $normalPrice, $specialPrice, $xtcPrice) {
        $discount = false;
        if ($_SESSION['currency'] === DEFAULT_CURRENCY) {
            $wmsa_more_than_amount = gm_get_conf('wmsa_more_than_amount');
            $wmsa_less_than_percentage = gm_get_conf('wmsa_less_than_percentage');
            $wmsa_operator = gm_get_conf('wmsa_operator');
            $wmsa_currency_symbol = gm_get_conf('wmsa_currency_symbol');
            $wmsa_trim_digits = gm_get_conf('wmsa_trim_digits');
            $discountAmount = $normalPrice - $specialPrice;
            if (!empty($_SESSION['customers_status']['customers_status_show_price_tax'])) {
                $discountAmount *= (1 + ($xtcPrice->TAX[xtc_get_tax_class_id($productId)] ?? 0) / 100);
            }
            $discountPercentage = (1 - ($specialPrice / $normalPrice)) * 100;
            switch ($wmsa_operator) {
                case 'or':
                    $isToConvert = ($discountAmount > $wmsa_more_than_amount || $discountPercentage < $wmsa_less_than_percentage);
                    break;
                case 'and':
                    $isToConvert = ($discountAmount > $wmsa_more_than_amount && $discountPercentage < $wmsa_less_than_percentage);
                    break;
                default:
                    $isToConvert = false;
            }
            if ($isToConvert) {
                $discountSrc = trim(str_replace([$_SESSION['currency'], '€', ',00'], ['', '', ',-'], $xtcPrice->xtcFormat($discountAmount, true)));
                if ($wmsa_trim_digits) {
                    $discountSrc = preg_replace('/[\.,][\d\-]+$/', '', $discountSrc);
                }
                $discount = '-' . $discountSrc . ' ' . (!empty($wmsa_currency_symbol) ? self::getCurrencySymbol() : $_SESSION['currency']);
            }
        }
        return $discount;
    }

    public static function getCurrencySymbol() {
        switch ($_SESSION['currency']) {
            case 'EUR':
                return '€';
            case 'USD':
                return '&#36;';
                break;
                return $_SESSION['currency'];
        }
    }
}
