<?php

class WMSonderpreisAbsolut extends AdminHttpViewController
{
    public const VERSION = '1.0.6';

    public static function getVersion() {
        return self::VERSION;
    }

    public function actionDefault() {
        $tplCurrencySymbol = $this->getCurrencySymbol();
        $wmsa_more_than_amount = gm_get_conf('wmsa_more_than_amount');
        $wmsa_less_than_percentage = gm_get_conf('wmsa_less_than_percentage');
        $wmsa_operator = gm_get_conf('wmsa_operator');
        $wmsa_currency_symbol = gm_get_conf('wmsa_currency_symbol');
        ob_start();
        include __DIR__ . '/../../Templates/settings.html';
        $content = ob_get_clean();
        return new AdminPageHttpControllerResponse('Sonderpreis absolut', $content);
    }

    public function actionSaveSettings() {
        gm_set_conf('wmsa_more_than_amount', $this->getFloatPostValueByKey('wmsa_more_than_amount'));
        gm_set_conf('wmsa_less_than_percentage', $this->getFloatPostValueByKey('wmsa_less_than_percentage'));
        gm_set_conf('wmsa_operator', $_POST['wmsa_operator'] === 'or' ? 'or' : 'and');
        gm_set_conf('wmsa_currency_symbol', isset($_POST['wmsa_currency_symbol']) ? 1 : 0);
        exit;
    }

    private function getFloatPostValueByKey($key) {
        return (float)str_replace(',', '.', $_POST[$key]);
    }

    private function getCurrencySymbol() {
        switch (DEFAULT_CURRENCY) {
            case 'EUR':
                return '€';
            case 'USD':
                return '&#36;';
                break;
                return DEFAULT_CURRENCY;
        }
    }
}
