<?php
class WMListImages extends AdminHttpViewController {
    private $modulUri = '';
    private $templateDir = '';
    private $dirs = ['images', 'images/icons', 'images/slider_images', 'images/product_images/gallery_images', 'images/product_images/gm_gmotion_images', 'images/product_images/info_images', 'images/product_images/popup_images', 'images/product_images/thumbnail_images'];
    private $imageFiles = ['jpg', 'png'];
    const VERSION = '1.0.1';
    public static function getVersion() {
        return self::VERSION;
    }
    public function actionDefault() {
        $this->modulUri = DIR_WS_CATALOG . 'GXModules/Werbe-Markt/Ladezeitoptimierung';
        $this->templateDir = __DIR__ . '/../../Templates';
        $this->assets->add(MainFactory::create('Asset', $this->modulUri . '/Admin/assets/css/style.css'));
        $this->assets->add(MainFactory::create('Asset', $this->modulUri . '/Admin/assets/js/ladezeitoptimierung.js'));
        $tplDirectoryRows = '';
        foreach ($this->dirs as $dir) {
            $dirInfo = $this->getDirInfo($dir);
            $tplDirectoryRows.= '<tr>';
            $tplDirectoryRows.= '<td><code>' . $dir . '</code></td>';
            $tplDirectoryRows.= '<td>' . $dirInfo['num'] . '</td>';
            $tplDirectoryRows.= '<td>' . $dirInfo['oldest'] . '</td>';
            $tplDirectoryRows.= '<td>' . $dirInfo['newest'] . '</td>';
            $tplDirectoryRows.= '<td>' . $dirInfo['button'] . '</td>';
            $tplDirectoryRows.= '</tr>';
        }
        eval('$content="' . $this->template('WMListImages') . '";');
        return new AdminPageHttpControllerResponse('WMListImages', $content, $this->assets);
    }
    private function template($src) {
        return str_replace('"', '\"', file_get_contents($this->templateDir . '/' . $src . '.html'));
    }
    private function getDirInfo($dir) {
        $completeDir = DIR_FS_CATALOG . $dir . '/';
        $files = scandir($completeDir);
        $ret = ['num' => 0, 'oldest' => $_SERVER['REQUEST_TIME'], 'newest' => 0];
        foreach ($files as $file) {
            $ext = strtolower(array_pop(explode('.', $file)));
            if (in_array($ext, $this->imageFiles)) {
                $ret['num']++;
                $filemtime = filemtime($completeDir . $file);
                if ($filemtime < $ret['oldest']) {
                    $ret['oldest'] = $filemtime;
                }
                if ($filemtime > $ret['newest']) {
                    $ret['newest'] = $filemtime;
                }
            }
        }
        if (empty($ret['num'])) {
            $ret = ['num' => '-', 'oldest' => '-', 'newest' => '-', 'button' => ''];
        } else {
            $ret['num'] = number_format($ret['num'], 0, '', '.');
            $ret['oldest'] = date('d.m.Y, H:i', $ret['oldest']);
            $ret['newest'] = date('d.m.Y, H:i', $ret['newest']);
            $ret['button'] = '<form action="' . DIR_WS_CATALOG . 'shop.php" method="get" target="_blank"><input type="hidden" name="do" value="ListImagesByDir"><input type="hidden" name="dir" value="' . $dir . '">Bilddateien neuer als <input type="number" name="minage" value="7"><input type="hidden" name="token" value="' . md5($dir . DB_SERVER_PASSWORD) . '"> Tage <button>Anzeigen</button></form>';
        }
        return $ret;
    }
}
