<?php
class ListImagesByDir extends HttpViewController {
    private $imageFiles = ['jpg', 'png'];
    private $perPage = 150;
    public function actionDefault() {
        $dir = isset($_GET['dir']) ? urldecode($_GET['dir']) : '';
        $minage = isset($_GET['minage']) ? (float)$_GET['minage'] : 0.0;
        $start = isset($_GET['start']) ? (int)$_GET['start'] : 0;
        $limit = $start + $this->perPage;
        if (isset($_GET['token']) && !empty($_GET['dir']) && isset($_GET['minage']) && $_GET['token'] === md5($_GET['dir'] . DB_SERVER_PASSWORD)) {
            $dir = DIR_FS_CATALOG . $_GET['dir'] . '/';
            $minTime = $_SERVER['REQUEST_TIME'] - $minage * 86400;
            $files = scandir($dir);
            $c = 0;
            echo '<h1>' . DIR_FS_CATALOG . $_GET['dir'] . '</h1>';
            echo '<h2>Bilddateien neuer als ' . $minage . ' Tage</h2>';
            $tplImages = '';
            foreach ($files as $file) {
                $ext = strtolower(array_pop(explode('.', $file)));
                if (in_array($ext, $this->imageFiles) && filemtime($dir . $file) > $minTime) {
                    if ($c >= $start && $c < $limit) {
                        $tplImages.= '<img src="' . DIR_WS_CATALOG . $_GET['dir'] . '/' . $file . '">';
                    }
                    $c++;
                }
            }
            echo '<style>.p,.pa,.p:hover{
padding:1px 3px;
border-radius:3px;
-moz-border-radius:3px;
-webkit-border-radius:3px;
margin:0.2em;
font-size:0.8em;
border:1px solid #000E1F;
}

.p{
background-color:transparent;
color:#000;
cursor:pointer;
}

.pa,.p:hover{
background-color:#000E1F;
color:#FFF;
}</style>';
            echo '<div style="float:right;">' . $this->pageSelButtons($c, $minage, $start) . '</div>';
            echo $tplImages;
        }
        die;
    }
    private function pageSelButtons($a, $minage, $start) {
        $bp_adm_text_next = "N&auml;chste";
        $bp_adm_text_previous = "Vorherige";
        $link = "shop.php?do=" . $_GET['do'] . "&amp;&dir=" . $_GET['dir'] . "&minage=" . $minage . "&token=" . $_GET['token'] . "&amp;start=";
        if ($this->perPage < 1) {
            $num_p = 1;
        } else {
            $num_p = (int)(($a - 1) / ($this->perPage)) + 1;
        }
        if ($start == 0) {
            $tpl = "<span class=\"pa\">1</span>";
        } else {
            $tpl = "<a href=\"" . substr($link, 0, -11) . "\" class=\"p\">1</a>";
        }
        $curr_p = (int)($start / $this->perPage) + 1;
        $p_plus = $num_p - $curr_p;
        if ($curr_p < 4 || $num_p <= 4) {
            $show_ps = array(1, 2, 3, 4);
        } elseif (1 == 2 && $p_plus < 3) {
            $show_ps = array(0, $num_p - 3, $num_p - 2, $num_p - 1);
        } else {
            $show_ps = array(0, $curr_p - 2, $curr_p - 1, $curr_p, $curr_p + 1);
        }
        for ($i = 0;$i < 4;$i++) {
            if ($show_ps[$i] < $num_p - 1) {
                $px = $show_ps[$i] + 1;
                $startx = $show_ps[$i] * $this->perPage;
                if ($show_ps[$i] == 0) {
                    $tpl.= " ... ";
                } elseif ($start == $show_ps[$i] * $this->perPage) {
                    $tpl.= "<span class=\"pa\" >" . $px . "</span>";
                } else {
                    $tpl.= "<a href=\"" . $link . $startx . "\" class=\"p\">" . $px . "</a>";
                }
            }
        }
        if ($start == ($num_p - 1) * $this->perPage) {
            $tpl.= "<span class=\"pa\">" . $num_p . "</span>";
        } else {
            $startx = ($num_p - 1) * $this->perPage;
            if (!in_array($num_p - 1, $show_ps)) {
                $tpl.= " ... ";
            }
            $tpl.= "<a href=\"" . $link . $startx . "\" class=\"p\">" . $num_p . "</a>";
        }
        $startx = $start - $this->perPage;
        if ($start != 0) {
            if ($startx == 0) {
                $tpl = "<a href=\"" . str_replace("&amp;start=", "", str_replace("?start=", "", $link)) . "\" class=\"p\">" . $bp_adm_text_previous . "</a>" . $tpl;
            } else {
                $tpl = "<a href=\"" . $link . $startx . "\" class=\"p\">" . $bp_adm_text_previous . "</a>" . $tpl;
            }
        }
        $startx = $start + $this->perPage;
        if ($start < ($num_p - 1) * $this->perPage) {
            $tpl.= "<a href=\"" . $link . $startx . "\" class=\"p\">" . $bp_adm_text_next . "</a>";
        }
        return $tpl;
    }
}
