<?php

class WMMassenangebot extends AdminHttpViewController
{
    public const VERSION = '1.1.0';
    private array $categoriesByParent = [];

    public static function getVersion() {
        return self::VERSION;
    }

    public function actionDefault() {
        $tplCustomerGroupSelection = $this->getCustomerGroupSelection();
        $tplCategorySelection = $this->getCategorySelection();
        $tplManufacturersSelection = $this->getManufacturersSelection();
        ob_start();
        include __DIR__ . '/../../Templates/angebote.html';
        $content = ob_get_clean();
        return new AdminPageHttpControllerResponse('Massenangebot', $content);
    }

    public function actionProcess() {
        $ret = '';
        switch ($_POST['filter_by']) {
            case 'category':
                if (empty($_POST['filter']['categories'])) {
                    exit('<div class="alert alert-danger" role="alert">Bitte Kategorie(n) auswählen!</div>');
                } else {
                    $filterQuery = "p.products_id IN (SELECT DISTINCT products_id FROM `products_to_categories` WHERE categories_id IN (" . implode(',', array_map(function ($category) {
                        return (int)$category;
                    }, $_POST['filter']['categories'])) . "))";
                }
                break;
            case 'manufacturer':
                if (empty($_POST['filter']['manufacturers'])) {
                    exit('<div class="alert alert-danger" role="alert">Bitte Hersteller auswählen!</div>');
                } else {
                    $filterQuery = "p.manufacturers_id IN (" . implode(',', array_map(function ($manufacturer) {
                        return (int)$manufacturer;
                    }, $_POST['filter']['manufacturers'])) . ")";
                }
                break;
        }
        switch ($_POST['offer_type']) {
            case 'special':
                $specialQuery = "SELECT specials_new_products_price FROM `specials` WHERE products_id=p2.products_id LIMIT 0,1";
                $priceName = 'Sonderpreis';
                break;
            case 'customer_group':
                $specialQuery = "SELECT personal_offer FROM `personal_offers_by_customers_status_" . (int)$_POST['customer_group']['group'] . "` WHERE products_id=p2.products_id LIMIT 0,1";
                $priceName = 'Kundengruppenpreis';
                break;
        }
        $discountFactor = 1 - ((float)str_replace(',', '.', $_POST[$_POST['offer_type']]['discount'])) / 100;
        $query = "SELECT
			p.products_id AS product_id, (" . $specialQuery . ") AS special_price, p.products_price AS price, p2.products_name AS name,
			(SELECT tr.tax_rate FROM " . TABLE_TAX_RATES . " tr, " . TABLE_ZONES_TO_GEO_ZONES . " ztgz WHERE tr.tax_class_id = p.products_tax_class_id AND tr.tax_zone_id = ztgz.geo_zone_id AND ztgz.zone_country_id = '" . (int)STORE_COUNTRY . "' ) AS tax_rate
        FROM
			`products_description` p2,
			" . TABLE_PRODUCTS . " p
		WHERE
			p.products_id=p2.products_id AND p2.language_id=" . (int)$_SESSION['languages_id'] . " AND
			" . $filterQuery . "
		ORDER BY
			p2.products_name ASC";
        $res = xtc_db_query($query);
        while ($date = xtc_db_fetch_array($res)) {
            if (empty($date['special_price'])) {
                $date['special_price'] = 0;
            } else {
                $deleteSpecialsProductIds[] = $date['product_id'];
            }
            if ($_POST['action'] === 'process' && $discountFactor !== 1.0) {
                $newNetSpecialPrice = $date['price'] * $discountFactor;
                switch ($_POST['offer_type']) {
                    case 'special':
                        $status = ((empty($_POST['special']['valid_from']) || strtotime($_POST['special']['valid_from']) < time()) && (empty($_POST['special']['valid_to']) || strtotime($_POST['special']['valid_to']) > time())) ? 1 : 0;
                        $insertQuery[] = "(" . $date['product_id'] . ",100000," . $newNetSpecialPrice . ",NOW(),NOW(),'" . (!empty($_POST['special']['valid_from']) ? date('Y-m-d H:i:s', strtotime($_POST['special']['valid_from'])) : null) . "',0,'" . (!empty($_POST['special']['valid_to']) ? date('Y-m-d H:i:s', strtotime($_POST['special']['valid_to'])) : null) . "',NULL," . $status . ")";
                        break;
                    case 'customer_group':
                        $insertQuery[] = "(" . $date['product_id'] . ",1," . $newNetSpecialPrice . ")";
                        break;
                }
            }
            if (PRICE_IS_BRUTTO == 'true') {
                $date['price'] = ($date['price'] * ($date['tax_rate'] + 100) / 100);
                $date['special_price'] = ($date['special_price'] * ($date['tax_rate'] + 100) / 100);
            }
            $newSpecialPrice = $date['price'] * $discountFactor;
            $ret .= '<tr><td><a href="categories.php?action=new_product&amp;pID=' . $date['product_id'] . '">' . $date['name'] . '</a></td><td class="text-right">' . number_format($date['price'], 2, ',', '.') . ' ' . DEFAULT_CURRENCY . '</td><td class="text-right">' . ($date['special_price'] === 0 ? '-' : number_format($date['special_price'], 2, ',', '.') . ' ' . DEFAULT_CURRENCY) . '</td><td class="text-right">' . ($discountFactor === 1.0 ? '-' : number_format($newSpecialPrice, 2, ',', '.') . ' ' . DEFAULT_CURRENCY) . '</td></tr>';
        }
        if (empty($ret)) {
            exit('<div class="alert alert-danger" role="alert">Keine passenden Artikel gefunden!</div>');
        } else {
            echo '<table><tr><th>Artikel</th><th>Normalpreis</th><th>Alter ' . $priceName . '</th><th>Neuer ' . $priceName . '</th></tr>' . $ret . '</table>';
            if ($_POST['action'] === 'process') {
                if (!empty($deleteSpecialsProductIds)) {
                    $query = "DELETE FROM `" . ($_POST['offer_type'] === 'special' ? 'specials' : 'personal_offers_by_customers_status_' . (int)$_POST['customer_group']['group']) . "` WHERE products_id IN (" . implode(',', $deleteSpecialsProductIds) . ")";
                    xtc_db_query($query);
                }
                if (!empty($insertQuery)) {
                    switch ($_POST['offer_type']) {
                        case 'special':
                            $query = "INSERT INTO `specials` (products_id,specials_quantity,specials_new_products_price,specials_date_added,specials_last_modified,begins_date,started,expires_date,date_status_change,status)";
                            break;
                        case 'customer_group':
                            $query = "INSERT INTO `personal_offers_by_customers_status_" . (int)$_POST['customer_group']['group'] . "` (products_id,quantity,personal_offer)";
                            break;
                    }
                    $query .= " VALUES " . implode(',', $insertQuery);
                    xtc_db_query($query);
                }
            }
        }
        exit;
    }

    private function getCustomerGroupSelection(): string {
        $ret = '';
        $query = "SELECT
			p1.customers_status_id, p1.customers_status_name, COUNT(p2.customers_id) AS num_customers
		FROM
			`customers_status` p1
		LEFT OUTER JOIN `customers` p2 ON (p2.customers_status=p1.customers_status_id)
		WHERE language_id=" . (int)$_SESSION['languages_id'] . "
		GROUP BY
			p1.customers_status_id
		ORDER BY
			p1.customers_status_name ASC";
        $res = xtc_db_query($query);
        while ($date = xtc_db_fetch_array($res)) {
            $ret .= '<option value="' . $date['customers_status_id'] . '">' . $date['customers_status_name'] . ' (' . $date['num_customers'] . ')</option>';
        }
        if (!empty($ret)) {
            $ret = '<select name="customer_group[group]">' . $ret . '</select>';
        }
        return $ret;
    }

    private function getManufacturersSelection(): string {
        $ret = '';
        $query = "SELECT
			p1.manufacturers_id, p1.manufacturers_name, COUNT(p2.products_id) AS num_products
		FROM
			`manufacturers` p1, `products` p2
		WHERE
			p1.manufacturers_id=p2.manufacturers_id
		GROUP BY
			p1.manufacturers_id
		ORDER BY
			p1.manufacturers_name ASC";
        $res = xtc_db_query($query);
        while ($date = xtc_db_fetch_array($res)) {
            $ret .= '<li><label><input type="checkbox" name="filter[manufacturers][]" value="' . $date['manufacturers_id'] . '">' . $date['manufacturers_name'] . ' (' . $date['num_products'] . ')</label>';
        }
        if (!empty($ret)) {
            $ret = '<ul>' . $ret . '</ul>';
        }
        return $ret;
    }

    private function getCategorySelection(): string {
        if (empty($this->categoriesByParent)) {
            $query = "SELECT
				p1.categories_id, p1.parent_id, p2.categories_name
			FROM
				`categories` p1, `categories_description` p2
			WHERE
				p1.categories_id=p2.categories_id AND p2.language_id=2
			ORDER BY
				categories_name ASC";
            $res = xtc_db_query($query);
            while ($date = xtc_db_fetch_array($res)) {
                $this->categoriesByParent[$date['parent_id']][$date['categories_id']] = $date['categories_name'];
            }
        }
        $ret = '<ul>';
        $this->buildCategorySelection(0, $ret);
        $ret .= '</ul>';
        return $ret;
    }

    private function buildCategorySelection(int $category, string &$ret) {
        foreach ($this->categoriesByParent[$category] as $categoryId => $categoryName) {
            $ret .= '<li><label><input type="checkbox" name="filter[categories][]" value="' . $categoryId . '">' . $categoryName . '</label>';
            if (!empty($this->categoriesByParent[$categoryId])) {
                $ret .= '<ul>';
                $this->buildCategorySelection($categoryId, $ret);
                $ret .= '</ul>';
            }
            $ret .= '</li>';
        }
    }
}
