<?php
class WMAusschlusslisteCacheControl extends WMAusschlusslisteCacheControl_parent {
    public function clear_data_cache() {
        $menuDir = __DIR__ . '/../../Menu/';
        if (is_dir($menuDir)) {
            $releaseInfoFile = DIR_FS_CATALOG . 'release_info.php';
            $version = 0;
            if (file_exists($releaseInfoFile)) {
                include ($releaseInfoFile);
                $version = preg_replace('/v(\d+\.\d+)\..*/', '$1', $gx_version);
            }
            $menuDirFiles = scandir($menuDir);
            $menuFiles = array_values(array_filter($menuDirFiles, function ($file) {
                return substr($file, -10) === '.menu.json';
            }));
            $menuFileSrc = array_values(array_filter($menuDirFiles, function ($file) {
                return substr($file, -14) === '.menu-src.json';
            }));
            if (version_compare(substr($gx_version, 1), '4.3') >= 0) {
                if (isset($menuFileSrc[0])) {
                    rename($menuDir . $menuFileSrc[0], $menuDir . substr($menuFileSrc[0], 0, -14) . '.menu.json');
                }
            } elseif (isset($menuFiles[0])) {
                rename($menuDir . $menuFiles[0], $menuDir . substr($menuFiles[0], 0, -10) . '.menu-src.json');
            }
        }
        return parent::clear_data_cache();
    }
}
