<?php
class WMAusschlussliste extends AdminHttpViewController {
    const VERSION = '1.0.2';
    private $categoriesByParent = [];
    public static function getVersion() {
        return self::VERSION;
    }
    public function actionDefault() {
        $tplCategorySelection = $this->getCategorySelection();
        $tplManufacturersSelection = $this->getManufacturersSelection();
        ob_start();
        include (__DIR__ . '/../../Templates/ausschlussliste.html');
        $content = ob_get_clean();
        return new AdminPageHttpControllerResponse('Ausschlussliste', $content);
    }
    public function actionProcess() {
        $ret = '';
        $whereQ = [];
        $query = "SELECT `products_id` FROM `products` WHERE `products_status`=1";
        if (!empty($_POST['exclude_product_ids'])) {
            $whereQ[] = "`products_id` NOT IN (" . implode(',', array_filter(preg_split('/\W+/u', preg_replace('/\D+/', ' ', $_POST['exclude_product_ids'])))) . ")";
        }
        if (!empty($_POST['exclude_specials'])) {
            $whereQ[] = "`products_id` NOT IN (SELECT `products_id` FROM `specials` WHERE `status`=1)";
        }
        if (!empty($_POST['filter']['manufacturers'])) {
            $whereQ[] = "`manufacturers_id` NOT IN (" . implode(',', array_map(function ($id) {
                return (int)$id;
            }, $_POST['filter']['manufacturers'])) . ")";
        }
        if (!empty($whereQ)) {
            $query.= " AND " . implode(' AND ', $whereQ);
        } else {
            $query.= ' AND 1=2';
        }
        $query2 = "SELECT `categories_id` FROM `categories` WHERE `categories_status`=1";
        if (!empty($_POST['filter']['categories'])) {
            $query2.= " AND `categories_id` NOT IN (" . implode(',', array_map(function ($id) {
                return (int)$id;
            }, $_POST['filter']['categories'])) . ")";
        } else {
            $query2.= ' AND 1=2';
        }
        $validProducts = $validCategories = [];
        $res = xtc_db_query($query);
        while ($date = xtc_db_fetch_array($res)) {
            $validProducts[] = $date['products_id'];
        }
        $res = xtc_db_query($query2);
        while ($date = xtc_db_fetch_array($res)) {
            $validCategories[] = $date['categories_id'];
        }
        $ret.= '<p>Liste der gültigen Artikel: <textarea class="w100">' . implode(',', $validProducts) . '</textarea></p>';
        $ret.= '<p>Liste der gültigen Kategorien: <textarea class="w100">' . implode(',', $validCategories) . '</textarea></p>';
        echo $ret;
        die;
    }
    private function getManufacturersSelection() {
        $ret = '';
        $query = "SELECT
			p1.manufacturers_id, p1.manufacturers_name, COUNT(p2.products_id) AS num_products
		FROM
			`manufacturers` p1, `products` p2
		WHERE
			p1.manufacturers_id=p2.manufacturers_id
		GROUP BY
			p1.manufacturers_id
		ORDER BY
			p1.manufacturers_name ASC";
        $res = xtc_db_query($query);
        while ($date = xtc_db_fetch_array($res)) {
            $ret.= '<li><label><input type="checkbox" name="filter[manufacturers][]" value="' . $date['manufacturers_id'] . '">' . $date['manufacturers_name'] . ' (' . $date['num_products'] . ')</label>';
        }
        if (!empty($ret)) {
            $ret = '<ul>' . $ret . '</ul>';
        }
        return $ret;
    }
    private function getCategorySelection() {
        if (empty($this->categoriesByParent)) {
            $query = "SELECT
				p1.categories_id, p1.parent_id, p2.categories_name
			FROM
				`categories` p1, `categories_description` p2
			WHERE
				p1.categories_id=p2.categories_id AND p2.language_id=2
			ORDER BY
				categories_name ASC";
            $res = xtc_db_query($query);
            while ($date = xtc_db_fetch_array($res)) {
                $this->categoriesByParent[$date['parent_id']][$date['categories_id']] = $date['categories_name'];
            }
        }
        $ret = '<ul>';
        $this->buildCategorySelection(0, $ret);
        $ret.= '</ul>';
        return $ret;
    }
    private function buildCategorySelection($category, &$ret) {
        foreach ($this->categoriesByParent[$category] as $categoryId => $categoryName) {
            $ret.= '<li><label><input type="checkbox" name="filter[categories][]" value="' . $categoryId . '">' . $categoryName . '</label>';
            if (!empty($this->categoriesByParent[$categoryId])) {
                $ret.= '<ul>';
                $this->buildCategorySelection($categoryId, $ret);
                $ret.= '</ul>';
            }
            $ret.= '</li>';
        }
    }
}
