<?php
namespace EigenschaftenArtikelbildAusnahmen\Helpers;
class ExcludeProducts {
    private static $instance;
    public function __construct() {
        self::$instance = $this;
    }
    public static function getInstance() {
        if (empty(self::$instance)) {
            $class = __CLASS__;
            self::$instance = new $class();
        }
        return self::$instance;
    }
    public function getExcludedProducts($products) {
        $excludedProducts = [];
        $productIds = array_map(function ($product) {
            if (isset($product['id'])) {
                if (!is_numeric($product['id'])) {
                    $product['id'] = preg_split('/\D/', $product['id']) [0];
                }
                return (int)$product['id'];
            }
            return null;
        }, $products);
        if (!empty($productIds)) {
            $exludeProductIds = [];
            $productIdsQ = implode(',', $productIds);
            $query = "SELECT DISTINCT
					`type_id`
				FROM
					`wm_eigenschaftenbilder_ausnahmen`
				WHERE
					(`type`='product' AND `type_id` IN (" . $productIdsQ . "))
					OR
					(`type`='category' AND `type_id` IN (
						SELECT DISTINCT categories_id FROM `products_to_categories` WHERE products_id IN (" . $productIdsQ . ")
					))";
            $res = xtc_db_query($query);
            while ($date = xtc_db_fetch_array($res)) {
                $exludeProductIds[] = $date['type_id'];
            }
            if (!empty($exludeProductIds)) {
                $excludedProducts = array_map(function ($product) {
                        return $product['id'];
                    }, array_filter($products, function ($product) use ($exludeProductIds) {
                        if (isset($product['id'])) {
                            return preg_match('/(' . implode('|', $exludeProductIds) . ')(\D|$)/', $product['id']);
                        }
                        return true;
                    }));
                }
            }
        return $excludedProducts;
    }
}
