<?php
namespace EigenschaftenArtikelbildAusnahmen\Helpers;
class CategoryProductExceptions {
    private $version = '1.0.0';
    private $title = '';
    private $content = '';
    public function __construct($type) {
        $this->setContent($type);
    }
    private function setContent($type) {
        $isProductExcluded = false;
        $isCategoryExcluded = false;
        switch ($type) {
            case 'product':
                $currentId = (int)$_GET['pID'];
                $query = "SELECT
					(SELECT COUNT(*) FROM `wm_eigenschaftenbilder_ausnahmen` WHERE `type`='product' AND `type_id`=" . $currentId . ") AS product_excluded,
					(SELECT COUNT(*) FROM `wm_eigenschaftenbilder_ausnahmen` WHERE `type`='category' AND `type_id` IN (
						SELECT categories_id FROM `products_to_categories` WHERE products_id=" . $currentId . "
					)) AS category_excluded";
                $res = xtc_db_query($query);
                while ($date = xtc_db_fetch_array($res)) {
                    $isProductExcluded = $date['product_excluded'] !== '0';
                    $isCategoryExcluded = $date['category_excluded'] !== '0';
                }
                $isExcluded = $isProductExcluded;
            break;
            case 'category':
                $currentId = (int)$_GET['cID'];
                $query = "SELECT COUNT(*) AS category_excluded FROM `wm_eigenschaftenbilder_ausnahmen` WHERE `type`='category' AND `type_id`=" . $currentId;
                $res = xtc_db_query($query);
                while ($date = xtc_db_fetch_array($res)) {
                    $isCategoryExcluded = $date['category_excluded'] !== '0';
                }
                $isExcluded = $isCategoryExcluded;
            break;
        }
        $this->title = 'Eigenschaften-/Attributebild';
        $this->content = '<div class="gx-container checkbox-switch-wrapper"><div data-gx-widget="checkbox"><input type="checkbox" name="eigenschaften_artikelbild_ausnahmen" value="1"' . ($isExcluded ? ' checked' : '') . ' id="EigenschaftenArtikelbildAusnahmenCheckbox" data-type="' . $type . '" data-id="' . $currentId . '"></div></div> &nbsp; Originalbild statt Eigenschaften-/Attributebild verwenden';
        if ($type === 'product' && $isCategoryExcluded){
			$this->content.= '<p class="alert alert-warning" role="alert">Für diesen Artikel wird aufgrund der Kategorie-Einstellung das Originalbild angezeigt.</p>';
		}
        $this->content.= '<script src="' . DIR_WS_CATALOG . 'GXModules/Werbe-Markt/EigenschaftenArtikelbildAusnahmen/Admin/assets/js/exclude.js?' . $this->version . '" defer></script>';
    }
    public function getTitle() {
        return $this->title;
    }
    public function getContent() {
        return $this->content;
    }
}
